#define pi 3.14159265359
#define hpi 0.5 * pi
#define rpi 1.0 / pi

#define tau pi * 2.0
#define htau 0.5 * tau
#define rtau 1.0 / tau

#define phi sqrt(5.0) * 0.5 + 0.5
#define golden_angle tau / phi / phi

#define saturate(x) clamp(x, 0.0, 1.0)
#define saturate_cos(x) clamp(x, -1.0, 1.0)

#define saturate_8(x) clamp(x, 0.0, 255.0)
#define saturate_16(x) clamp(x, 0.0, 65535.0)

#define fsign(x) (saturate(x * 1e35) * 2.0 - 1.0)
#define fstep(x,y) saturate((y - x) * 1e35)

#define log10(x) log(x) / log(10.0)
#define curve(x) x * x * (3.0 - 2.0 * x)

#define rotation(x) mat2(cos(x), -sin(x), sin(x), cos(x))

#define min0(x) min(x, 0.0)
#define min1(x) min(x, 1.0)

#define max0(x) max(x, 0.0)
#define max1(x) max(x, 1.0)

#define diagonal2(m) vec2((m)[0].x, (m)[1].y)
#define diagonal3(m) vec3(diagonal2(m), m[2].z)
#define diagonal4(m) vec4(diagonal3(m), m[2].w)

#define trans_mad(mat, v) (mat3(mat) * (v) + (mat)[3].xyz)
#define proj_mad(mat, v) (diagonal3(mat) * (v) + (mat)[3].xyz)

#define norm(x) x * inversesqrt(dot(x, x))
#define condition(x, y) x == y ? true : false
#define lerp(x, y, z) (y - x) * z + x
#define rcp(x) (1.0 / x)

float min2(vec2 x){
    return min(x.x, x.y);
}

float min3(vec3 x){
    return min(x.x, min(x.y, x.z));
}

float max2(vec2 x){
    return max(x.x, x.y);
}

float max3(vec3 x){
    return max(x.x, max(x.y, x.z));
}

float pow2(float x){
    return x*x;
    //cost: 1
}
float pow3(float x){
    return x*x*x;
    //cost: 2
}
float pow4(float x){
    return pow2(pow2(x));
    //cost: 2
}
float pow5(float x){
    return pow4(x)*x;
    //cost: 3
}
float pow6(float x){
    return pow3(pow2(x));
    //cost: 3
}
float pow7(float x){
    return pow3(pow2(x))*x;
    //cost: 4
}
float pow8(float x){
    return pow2(pow4(x));
    //cost: 3
}

vec2 pow2(vec2 x){
    return x*x;
    //cost: 1
}
vec2 pow3(vec2 x){
    return x*x*x;
    //cost: 2
}
vec2 pow4(vec2 x){
    return pow2(pow2(x));
    //cost: 2
}
vec2 pow5(vec2 x){
    return pow4(x)*x;
    //cost: 3
}
vec2 pow6(vec2 x){
    return pow3(pow2(x));
    //cost: 3
}
vec2 pow7(vec2 x){
    return pow3(pow2(x))*x;
    //cost: 4
}
vec2 pow8(vec2 x){
    return pow2(pow4(x));
    //cost: 3
} 

vec3 pow2(vec3 x){
    return x*x;
    //cost: 1
}
vec3 pow3(vec3 x){
    return x*x*x;
    //cost: 2
}
vec3 pow4(vec3 x){
    return pow2(pow2(x));
    //cost: 2
}
vec3 pow5(vec3 x){
    return pow4(x)*x;
    //cost: 3
}
vec3 pow6(vec3 x){
    return pow3(pow2(x));
    //cost: 3
}
vec3 pow7(vec3 x){
    return pow3(pow2(x))*x;
    //cost: 4
}
vec3 pow8(vec3 x){
    return pow2(pow4(x));
    //cost: 3
} 

vec4 pow2(vec4 x){
    return x*x;
    //cost: 1
}
vec4 pow3(vec4 x){
    return x*x*x;
    //cost: 2
}
vec4 pow4(vec4 x){
    return pow2(pow2(x));
    //cost: 2
}
vec4 pow5(vec4 x){
    return pow4(x)*x;
    //cost: 3
}
vec4 pow6(vec4 x){
    return pow3(pow2(x));
    //cost: 3
}
vec4 pow7(vec4 x){
    return pow3(pow2(x))*x;
    //cost: 4
}
vec4 pow8(vec4 x){
    return pow2(pow4(x));
    //cost: 3
} 