vec3 sun(vec3 position, vec3 direction){
    atmosphere_constant ac = atmosphere_s();

    float theta = dot(position, direction);
    float disc = saturate(acos(theta) / ac.sun_angular_radius);

    return theta < cos(ac.sun_angular_radius) ? vec3(0.0) : temperature_to_rgb(5778.0) * rpi * (ac.sun_luminance / ac.sun_illuminance) * disc;
}

vec3 moon(vec3 position, vec3 sun_direction, vec3 moon_direction){
    atmosphere_constant ac = atmosphere_s();

    const float roughness = 0.9;            //Between 0.7 and 0.95

    vec2 sphere = ray_sphere_intersection(-moon_direction, position, ac.moon_angular_radius);
    vec3 normal = normalize(position * sphere.x - moon_direction);

    vec3 H = normalize(sun_direction - position);

    float NdotL = dot(normal, sun_direction);
    float NdotV = dot(normal, -position);
    float LdotV = length(sun_direction - position);
    float NdotH = (NdotL + NdotV) * inversesqrt(2.0 + 2.0 * LdotV);

    vec3 albedo = vec3(0.318);
    vec3 direct_diffuse = saturate(NdotL) * hammon_diffuse(albedo, NdotL, NdotV, NdotH, LdotV, pow2(roughness));

    return sphere.y < 0.0 ? vec3(0.0) : albedo * direct_diffuse * ac.sun_luminance;
}

//Stars from nimitz
//https://www.shadertoy.com/view/XtGGRt

vec3 stars(vec3 position, vec3 direction){
    position = position * rotation_mat(vec3(0, 1, 0), direction);

    float sample_resolution = 1024.0 * 0.6;
	
	vec3 temp_min = temperature_to_rgb(3000.0);
	vec3 temp_max = temperature_to_rgb(20000.0);
	
    vec3 color = vec3(0.0);

    for(int i = 0; i < 4; ++i){
        vec3 q = fract(position * (0.15 * sample_resolution)) - 0.5;
        vec3 id = floor(position * (0.15 * sample_resolution));

        vec2 rn = hash33(id).xy;

        float c2 = 1.0 - smoothstep(0.0, 0.3, length(q));
              c2 *= fstep(rn.x, 0.05 + pow2(i) * 0.001);

        color += c2 * (mix(temp_min, temp_max, rn.y) * 0.6 + 0.9);
        position *= 1.3;
    }

    return srgb_to_linear(color) * 24.0;
}