vec3 water_color(vec2 depth, float color){
    water_settings ws = water_s();

    float translucent_depth0 = (depth.x * 8.0 - 4.0) * shadowProjectionInverse[2].z + shadowProjectionInverse[3].z;
    float translucent_depth1 = (depth.y * 8.0 - 4.0) * shadowProjectionInverse[2].z + shadowProjectionInverse[3].z;

    float density = 0.25 * (translucent_depth1 - translucent_depth0);
    float caustics_depth = saturate(density * 2.0);

    return exp2(ws.attenuation_coefficient * density);
}

vec3 rsm(materials m, vec3 position, vec3 normal, float noise, float lightmap){
    shadow_settings s = shadow_s();

    const float noise_size = pow2(8.0);

    float noise0 = noise * noise_size + 0.5;
    float noise1 = noise0 / noise_size;

    vec2 dir = sincos(noise0 * golden_angle);
    mat2 rot = rotation(noise_size * golden_angle);

    vec3 shadow_position = world_to_shadowspace(position);
    vec3 shadow_normal = mat3(shadowModelView) * normal * vec3(1.0, 1.0, -1.0);

    vec3 color = vec3(0.0);

    const float radius_squared = 2.0 * s.radius;
    const float radius_offset = radius_squared / 2048.0;
    const float radius_inverse = 1.0 / radius_squared * pi;

    for(int i = 0; i < s.steps2; i++, dir *= rot){
        vec2 offset = dir * (i + noise1) / s.steps2;
             
        vec2 offset_shadow = shadow_position.xy + offset * radius_offset;
        vec2 offset_dist = shadow_distortion(s, offset_shadow) * 0.5 + 0.5;

        float depth0 = texture2(shadowtex0, offset_dist).x;
        float depth1 = texture2(shadowtex1, offset_dist).x;
          
        uvec3 data = texture(shadowcolor0, offset_dist).xyz;

        float caustics = unpackUnorm4x8(data.y).x;
        float s_lightmap = unpackUnorm4x8(data.y).y;
        float ID = unpackUnorm4x8(data.y).z * 255.0;

        bool water = condition(ID, 2);
        bool grass = condition(ID, 6);
        bool leaves = condition(ID, 7);

        vec3 albedo = unpackUnorm4x8(data.x).xyz;
             albedo *= water ? water_color(vec2(depth0, depth1), caustics) : vec3(1.0);

        vec3 s_normal = decode_unit_vector(unpackUnorm4x8(data.z).xy);
             s_normal.xy = -s_normal.xy;
             
        vec3 s_position = vec3(offset_shadow, depth1 * 8.0 - 4.0) - shadow_position; if(dot(s_position, s_position) > radius_squared) continue;
        vec3 s_vector = norm(s_position);

        float NdotL = saturate(dot(s_vector, shadow_normal));
        float NdotV = saturate(dot(s_vector, s_normal));

        if(NdotL <= 0.0) continue;
        if(NdotV <= 0.0) continue;

        NdotL = m.grass || m.leaves ? 0.5 : NdotL;

        float falloff = (dot(s_position, s_position) * radius_inverse * 16384.0 + radius_inverse * 16.0);

        lightmap = saturate(lightmap);
        //lightmap = 1.0 - pow(1.0 - lightmap, 0.7);
        lightmap = pow2(lightmap);

        float lightmap_mask = (s_lightmap - lightmap);
              lightmap_mask = pow6(lightmap_mask);
              lightmap_mask = saturate(0.005 / max(lightmap_mask, 0.005));

        color += albedo * NdotL * NdotV * rcp(falloff) * lightmap_mask;
    }

    #ifdef GI
        return s.brightness * (color * radius_inverse);
    #else
        return vec3(0.0);
    #endif
}