#include "/program/shaders1/common/shadow/pcss.glsl"
#include "/program/shaders1/common/shadow/contact.glsl"

vec3 color_shadow(vec2 depth, vec2 shadow_depth, vec4 albedo, float color, float mat){
    water_settings ws = water_s();

    float translucent_depth0 = (depth.x * 8.0 - 4.0) * shadowProjectionInverse[2].z + shadowProjectionInverse[3].z;
    float translucent_depth1 = (depth.y * 8.0 - 4.0) * shadowProjectionInverse[2].z + shadowProjectionInverse[3].z;

    float density = translucent_depth1 - translucent_depth0;
    float caustics_depth = saturate(density * 2.0);

    #ifdef WATER_CAUSTICS
        float caustics = pow(color * 8.0, WATER_CAUSTICS_STRENGTH);
              caustics = caustics + caustics_depth * (1.0 - caustics_depth);
    #else
        float caustics = 1.0;
    #endif

    if(mat == 2){
        return mix(vec3(shadow_depth.x), exp(ws.attenuation_coefficient * ws.density * density) * caustics, saturate(shadow_depth.y - shadow_depth.x));
    } else {
        return mix(vec3(shadow_depth.x), srgb_to_linear(albedo.xyz * (1.0 - albedo.w)), saturate(shadow_depth.y - shadow_depth.x));
    }
}

vec3 soft_shadow(materials m, vec3 position, vec3 noise, float NdotL){
    shadow_settings s = shadow_s();

    vec3 shadow = vec3(0.0);
    vec3 shadow_position = world_to_shadowspace(position);
    vec3 shadow_out_position = shadow_distortion(s, shadow_position) * 0.5 + 0.5;

    NdotL = m.grass || m.leaves || m.fire || m.textured ? 0.5 : NdotL;

    if(NdotL < 0.001 || any(greaterThanEqual(abs(shadow_out_position), vec3(1.0)))) return vec3(0.0);

    float bias = (2048.0 / s.resolution) + sqrt(sqrt(1.0 - NdotL * NdotL) / NdotL);
          bias = bias * distortion(s, shadow_position.xy) * 0.0005;

    float radius = pcss(shadow_position, noise, bias);
    
    if(m.leaves){
        radius = 0.0025;    
    }

    for(int i = 0; i < s.steps0; ++i){
        vec2 offset = sample_disk(i, noise.x, s.steps0);

        vec3 shadow_position = vec3(offset, -bias) * radius + shadow_position;
             shadow_position = shadow_distortion(s, shadow_position) * 0.5 + 0.5;

        float depth0 = texture2(shadowtex0, shadow_position.xy).x;
        float depth1 = texture2(shadowtex1, shadow_position.xy).x;

        float shadow_depth0 = depth0 > shadow_position.z - bias ? 1.0 : 0.0;
        float shadow_depth1 = depth1 > shadow_position.z - bias ? 1.0 : 0.0;

        uvec3 data = texture(shadowcolor0, shadow_position.xy).xyz;
        vec4 albedo = unpackUnorm4x8(data.x);

        float caustics = unpackUnorm4x8(data.y).x;
        float ID = unpackUnorm4x8(data.y).z * 255.0;

        shadow += color_shadow(vec2(depth0, depth1), vec2(shadow_depth0, shadow_depth1), albedo, caustics, ID);
    }

    return shadow / float(s.steps0);
}

vec3 hard_shadow(materials m, vec3 position, float NdotL){
    shadow_settings s = shadow_s();

    vec3 shadow = vec3(0.0);
    vec3 shadow_position = world_to_shadowspace(position);
    vec3 shadow_out_position = shadow_distortion(s, shadow_position) * 0.5 + 0.5;

    NdotL = m.grass || m.leaves || m.fire || m.textured ? 0.5 : NdotL;

    if(NdotL < 0.001 || any(greaterThanEqual(abs(shadow_out_position), vec3(1.0)))) return vec3(0.0);

    float bias = (2048.0 / s.resolution) + sqrt(sqrt(1.0 - NdotL * NdotL) / NdotL);
          bias = bias * distortion(s, shadow_position.xy) * 0.0005;

    shadow_position = shadow_distortion(s, shadow_position) * 0.5 + 0.5;

    float depth0 = texture2(shadowtex0, shadow_position.xy).x;
    float depth1 = texture2(shadowtex1, shadow_position.xy).x;

    //bias = (depth0 == depth1) ? (dot(shadow_normal, s_normal) > 0.1 ? bias : bias * 0.5) : bias;

    float shadow_depth0 = depth0 > shadow_position.z - bias ? 1.0 : 0.0;
    float shadow_depth1 = depth1 > shadow_position.z - bias ? 1.0 : 0.0;

    uvec3 data = texture(shadowcolor0, shadow_position.xy).xyz;
    vec4 albedo = unpackUnorm4x8(data.x);

    float caustics = unpackUnorm4x8(data.y).x;
    float ID = unpackUnorm4x8(data.y).z * 255.0;

    shadow += color_shadow(vec2(depth0, depth1), vec2(shadow_depth0, shadow_depth1), albedo, caustics, ID);

    return NdotL < 0.0001 ? vec3(1.0) : shadow;
}