const vec2 dof_samples[40] = vec2[40](vec2(0.0, 0.0),
                                    vec2(0.0, 0.4),
                                    vec2(0.15, 0.37),
                                    vec2(0.29, 0.29),
                                    vec2(-0.37, 0.15),
                                    vec2(0.4, 0.0),
                                    vec2(0.37, -0.15),
                                    vec2(0.29, -0.29),
                                    vec2(-0.15, -0.37),                               
                                    vec2(0.0, 0.4),
                                    vec2(-0.15, 0.37),
                                    vec2(-0.29, 0.29),
                                    vec2(0.37, 0.15),
                                    vec2(-0.4, 0.0),
                                    vec2(-0.37, -0.15),
                                    vec2(-0.29, 0.29),

                                    vec2(0.15, -0.37),
                                    vec2(0.15, 0.37),
                                    vec2(-0.37, 0.15),
                                    vec2(0.37, -0.15),
                                    vec2(-0.15, -0.37),
                                    vec2(-0.15, 0.37),
                                    vec2(0.37, 0.15),
                                    vec2(-0.37, -0.15),

                                    vec2(0.29, 0.29),
                                    vec2(0.4, 0.0),
                                    vec2(0.29, -0.29),
                                    vec2(0.0, -0.4),
                                    vec2(-0.29, 0.29),
                                    vec2(-0.4, 0.0),
                                    vec2(-0.29, -0.29),
                                    vec2(0.0, 0.4),

                                    vec2(0.29, 0.29),
                                    vec2(0.4, 0.0),
                                    vec2(0.29, -0.29),
                                    vec2(0.0, -0.4),
                                    vec2(-0.29, 0.29),
                                    vec2(-0.4, 0.0),
                                    vec2(-0.29, -0.29),
                                    vec2(0.0, 0.4)); 

vec3 depth_of_field(vec2 coord){
    dof_settings d = sdof();

    float depth0 = -projection_depth(texture2(depthtex0, coord).x);
    float depth1 = -projection_depth(centerDepthSmooth);

    float focus = d.aperture * d.focal * abs(depth1 - depth0) / (depth1 * abs(depth0 - d.focal));
          focus = clamp(focus * d.strength, -d.maxBlur, d.maxBlur);

    if(texture(depthtex0, coord).x < 0.7) focus *= float(depth0 < depth1);

    vec3 color = vec3(0.0);
    float weight = 0.0;

    #ifdef DEPTH_OF_FIELD
        for(int i = 0; i < d.steps; i++){
            float sample_lod = d.mipmap * abs(focus);
            float sample_weight = filter_gaussian(sample_lod, 2.0);

            #ifdef DOF_CHROMATIC_ABERRATION
                float dist = pow2(distance(coord, vec2(0.5)));

                vec2 offset_r = (dof_samples[i] + vec2(d.ca_strength * dist, 0.0)) * vec2(1.0, aspectRatio) * focus / d.steps;
                vec2 offset_b = (dof_samples[i] - vec2(d.ca_strength * dist, 0.0)) * vec2(1.0, aspectRatio) * focus / d.steps;
                vec2 offset_g = dof_samples[i] * vec2(1.0, aspectRatio) * focus / d.steps;

                float r = texture2_lod(colortex8, coord + offset_r, sample_lod).x;
                float g = texture2_lod(colortex8, coord + offset_g, sample_lod).y;
                float b = texture2_lod(colortex8, coord + offset_b, sample_lod).z;

                color += vec3(r, g, b) * sample_weight;
            #else
                vec2 offset = dof_samples[i] * vec2(1.0, aspectRatio) * focus / d.steps;
                     offset = coord + offset;

                color += texture2_lod(colortex8, offset, sample_lod).xyz * sample_weight;
            #endif

            weight += sample_weight;
        }

        return color / weight;
    #else
        return texture2(colortex8, coord).xyz;
    #endif
}